<?php declare(strict_types=1);

namespace Magmodules\TradeTracker\Migration;

use Doctrine\DBAL\Connection;
use Shopware\Core\Framework\Migration\MigrationStep;

class Migration1669963256ProductFeed extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1669963256;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement('CREATE TABLE IF NOT EXISTS `magmodules_product_feed` (
                `id` BINARY(16) NOT NULL,
                `sales_channel_id` BINARY(16) NULL,
                `product_feed_url` VARCHAR(255) NULL,
                `product_count` INT(11) NULL,
                `updated_at` DATETIME(3) NULL,
                `created_at` DATETIME(3) NOT NULL,
                PRIMARY KEY (`id`),
                KEY `fk.magmodules_product_feed.sales_channel_id` (`sales_channel_id`),
                CONSTRAINT `fk.magmodules_product_feed.sales_channel_id` FOREIGN KEY (`sales_channel_id`) REFERENCES `sales_channel` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci');
    }

    public function updateDestructive(Connection $connection): void
    {
        // implement update destructive
    }
}
