const { Component, Mixin } = Shopware;
import template from './trade-tracker-test-button.twig';

Component.register('trade-tracker-test-button', {
    template,

    props: [
        'label'
    ],

    inject: [
        'TradeTrackerApiCredentialsService'
    ],

    mixins: [
        Mixin.getByName('notification')
    ],

    data() {
        return {
            isLoading: false,
            isSaveSuccessful: false,
        };
    },

    computed: {
    },

    methods: {
        saveFinish() {
            this.isSaveSuccessful = false;
        },

        check() {
            this.isLoading = true;

            this.TradeTrackerApiCredentialsService.validateSandboxApi().then(response => {
                if (response.success === true) {
                    // show success
                    this.createNotificationSuccess({
                        title: this.$tc('trade-tracker.general.api.messages.success.title'),
                        message: this.$tc('trade-tracker.general.api.messages.success.message')
                    });
                } else {
                    // show error
                    this.createNotificationError({
                        title: this.$tc('trade-tracker.general.api.messages.error.title'),
                        message: this.$tc('trade-tracker.general.api.messages.error.message')
                    });
                }

                this.isLoading = false;
            });
        }
    }
})
