import template from './webshopnl-configuration.html.twig';
import './webshopnl-configuration.scss';

const { Component, Mixin, Defaults } = Shopware;
const { Criteria } = Shopware.Data;

Component.register('webshopnl-configuration',{

    template,

    inject: [
        'repositoryFactory',
        'configService',
        'systemConfigApiService',
        'acl',
    ],

    mixins: [
        Mixin.getByName('notification'),
    ],

    data(){
        return {
            isLoading: false,
            isLoadingPreview: false,
            isLoadingGenerate: false,
            isLoadingDownload: false,
            isSaveSuccessful: false,
            extraFieldsData: [],
            domainId : null,
            configsaleschannel: null,
            apiConfig : null,
            config : null,
            salesChannels: [],
            salesChannelMain: { salesChannelId : null, id :null },
            propertyGroup : [],
            shippingMethod : [],
            productFeedData : null,
            productUrl :null,
            customerGroup : [],
            previewDisable :false,
            isLoadingLoad : false,
            isLoadingAccount : false,
            brandParam:[{id:'manufacture', name:'Manufacture'}],
            colorParam:[{id:'yes', name:'Yes'},{id:'no', name:'No'}],
            descriptionParam:[{id:'yes', name:'Yes'},{id:'no', name:'No'}],
            useParentImageParam:[{id:'yes', name:'Yes'},{id:'no', name:'No'}],
            sortDirection: 'ASC',
            sortBy: 'name'
        }
    },

    watch: {
        config: {
            handler() {
                this.domainId = this.$refs.configComponent.selectedSalesChannelId;
                this.productFeedData = null;
                this.getProductFeed();
            },
            deep: true
        }
    },

    computed: {
        salesChannelRepository() {
            return this.repositoryFactory.create('sales_channel');
        },

        propertyRepository() {
            return this.repositoryFactory.create('property_group');
        },

        shippingRepository() {
            return this.repositoryFactory.create('shipping_method');
        },

        webshopnlProductFeedRepository() {
             return this.repositoryFactory.create('magmodules_wevshopnl_product_feed');
        },

        customerGroupRepository() {
             return this.repositoryFactory.create('customer_group');
        },

        extraFieldsColumn() {
            return [
                { property: 'field', label: this.$tc('webshopnl-configuration.product.fieldLabel'), visible: true,},
                { property: 'attribute', label: this.$tc('webshopnl-configuration.product.attributeLabel')}
            ]
        },
    },

    created() {
        this.createdComponent();
        this.getProductProperties();
        this.getShippingMethod();
        this.getCustomerGroup();
        this.getProductFeed();
    },

    methods:{
        generate(salesChannelMainId) {
            let data = new FormData();
            data.append('salesChannelId', salesChannelMainId);
            let headers = this.configService.getBasicHeaders();

            var generalEnable = this.systemConfigApiService.getValues('MagmodulesWebshopnl.config');
             console.log(generalEnable)
            if (generalEnable) {
                console.log(generalEnable)
                return this.configService.httpClient.post('/generate/feedproduct', data, {headers}).then((response) => {
                if (response.data.type === 'Success') {
                    this.getProductFeed();
                    this.createNotificationSuccess({
                            title: this.$tc('webshopnl-configuration.action.titleProductFeedSuccess'),
                            message: this.$tc('webshopnl-configuration.action.messageProductFeedSuccess')
                        });
                    } else {
                        this.createNotificationError({
                            title: this.$tc('webshopnl-configuration.action.titleProductFeedFailed'),
                            message: this.$tc('webshopnl-configuration.action.messageProductFeedFailed')
                        });
                    }
                }).finally(() => {
                    this.isLoading = false;
                });
            }

        },

        getShippingMethod() {
            const shippingCriteria = new Criteria();
            this.shippingRepository.search(shippingCriteria, Shopware.Context.api)
                 .then((entity) => {
                     entity.forEach((name) => {
                          this.shippingMethod.push(name);
                     });
                     return this.shippingMethod;
                 });
        },

        getProductFeed() {
            if (this.domainId) {
                const criteria = new Criteria();
                criteria.addFilter(Criteria.equals('salesChannelId', this.domainId));
                criteria.addSorting(Criteria.sort('createdAt', 'DESC'));
                criteria.setLimit(1);
                this.webshopnlProductFeedRepository.search(criteria, Shopware.Context.api)
                    .then(async (entity) => {
                    if (entity.total > 0) {
                         this.productFeedData = entity[0];
                         this.productUrl = entity[0].productFeedUrl;
                         if (this.productUrl) {
                            this.previewDisable = true;
                         }
                    }
                });
            }
        },

        download() {
            let data = new FormData();
            data.append('productUrl', this.productUrl);
            this.isLoadingAccount = true;
                let headers = this.configService.getBasicHeaders();
                return this.configService.httpClient.post('/download/productFeed', data, { headers }).then((response) => {
                this.isLoadingAccount = false;
                    if (response.data.type === 'error') {
                        this.createNotificationError({
                            title: response.data.type,
                            message: "error stop"
                        });
                        return;
                    }
                    if (response.data.type === 'Success') {
                        this.createNotificationSuccess({
                            title: response.data.type,
                            message: response.data.message
                        });
                }
            });
        },

        getCustomerGroup() {
            const customerGroupCriteria = new Criteria();
            this.customerGroupRepository.search(customerGroupCriteria, Shopware.Context.api)
                .then((entity) => {
                entity.forEach((name) => {
                     this.customerGroup.push(name);
                });
                return this.customerGroup;
            });
        },

        preview() {
            Axios.get(url, { responseType: 'blob' })
                .then(response => {
                    const blob = new Blob([response.data], { type: 'application/ndjosn' })
                    const link = document.createElement('a')
                    link.href = URL.createObjectURL(blob)
                    link.download = label
                    link.click()
                    URL.revokeObjectURL(this.productUrl)
            }).catch(console.error)
        },

        getProductProperties() {
            const criteria = new Criteria();
            criteria.addSorting(Criteria.sort(this.sortBy, this.sortDirection, this.useNaturalSorting));
            criteria.addAssociation('options');

            this.propertyRepository.search(criteria, Shopware.Context.api)
                .then((entity) => {
                    entity.forEach((name) => {
                        this.propertyGroup.push(name);
                    });
                    return this.propertyGroup;
                });
        },

        createdComponent() {
            this.isLoading = true;
            const criteria = new Criteria();
            criteria.addFilter(
                Criteria.equalsAny('typeId', [
                    Defaults.storefrontSalesChannelTypeId,
                    Defaults.apiSalesChannelTypeId
                ])
            );

            this.salesChannelRepository.search(criteria, Shopware.Context.api).then(res => {
                res.add({id: null,
                    translated: {
                        name: this.$tc('sw-sales-channel-switch.labelDefaultOption')
                    }
                });
                this.salesChannels = res;

            }).finally(() => {
                this.isLoading = false;
            });
        },

        useParentImage(useParentImageParam) {
            return useParentImageParam;
        },

        color(colorParam) {
            return colorParam;
        },

        brand(brandParam) {
            return brandParam;
        },

        checkTextFieldInheritance(value) {
            if (typeof value !== 'string') {
                return true;
            }

            return value.length <= 0;
        },

        checkBoolFieldInheritance(value) {
            return typeof value !== 'boolean';
        },

        autoApproveOptions(autoApproveParam){
            return autoApproveParam;
        },

        widgetTypeOptions(widgetTypeParam) {
            return widgetTypeParam;
        },

        widgetCheckoutTypeOptions(widgetCheckoutTypeParam) {
            return widgetCheckoutTypeParam;
        },

        widgetTypePositionOptions(widgetTypeParam) {
            return widgetTypeParam;
        },

        widgetTypeCheckoutOptions(widgetTypeCheckoutParam) {
            return widgetTypeCheckoutParam;
        },

        floatingPositionOptions(floatingPositionTypeParam) {
            return floatingPositionTypeParam;
        },

        getLocation() {
            const criteria = new Criteria();
            this.locationRepository.search(criteria, Shopware.Context.api)
                .then((entity) => {
                    entity.forEach((name) => {
                        this.locationOption.push(name);
                    });
                    return this.locationOption;
                });
        },

        onSave() {
            this.isLoading = true;

            /* const updatePromises = [];
            updatePromises.push(this.repository.save(this.frequency).then(() => {
                Promise.all(updatePromises).then(() => {
                })
            }));*/

            this.$refs.configComponent.save().then(() => {
                this.isSaveSuccessful = true;
                this.createNotificationSuccess({
                    title: this.$tc('webshopnl-configuration.action.titleSaveSuccess'),
                    message: this.$tc('webshopnl-configuration.action.messageSaveSuccess')
                });
            }).finally(() => {
                this.isLoading = false;
            });
        }
    }
})
