<?php declare(strict_types=1);

namespace MagmodulesWebshopnl\Core\Content\WebShopOrder;

use Shopware\Core\Checkout\Order\OrderDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\EntityDefinition;
use Shopware\Core\Framework\DataAbstractionLayer\Field\CreatedAtField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\FkField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\PrimaryKey;
use Shopware\Core\Framework\DataAbstractionLayer\Field\Flag\Required;
use Shopware\Core\Framework\DataAbstractionLayer\Field\IdField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ManyToOneAssociationField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\ReferenceVersionField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\StringField;
use Shopware\Core\Framework\DataAbstractionLayer\Field\UpdatedAtField;
use Shopware\Core\Framework\DataAbstractionLayer\FieldCollection;
use Shopware\Core\System\SalesChannel\SalesChannelDefinition;

class WebShopOrderDefinition extends EntityDefinition
{
    public const ENTITY_NAME = 'magmodules_webshopnl_order';

    public function getEntityName(): string
    {
        return self::ENTITY_NAME;
    }

    public function getCollectionClass(): string
    {
        return WebShopOrderCollection::class;
    }

    public function getEntityClass(): string
    {
        return WebShopOrderEntity::class;
    }

    protected function defineFields(): FieldCollection
    {
        return new FieldCollection([
            (new IdField('id', 'id'))->addFlags(new Required(), new PrimaryKey()),
            (new FkField('sales_channel_id', 'salesChannelId', SalesChannelDefinition::class)),
            (new StringField('web_shop_order_id', 'webShopOrderId')),
            (new FkField('order_id', 'orderId', OrderDefinition::class)),
            (new ReferenceVersionField(OrderDefinition::class, "order_version_id")),
            (new StringField('merchant_id', 'merchantId')),
            (new StringField('status', 'status')),
            new ManyToOneAssociationField('salesChannel', 'sales_channel_id', SalesChannelDefinition::class, 'id'),
            new ManyToOneAssociationField('order', 'order_id', OrderDefinition::class, 'id'),
            new UpdatedAtField(),
            new CreatedAtField(),
        ]);
    }
}