<?php declare(strict_types=1);

namespace MagmodulesWebshopnl\Service;

use Doctrine\DBAL\Exception\UniqueConstraintViolationException;
use Exception;
use Monolog\Logger;
use Psr\Log\LoggerInterface;
use Shopware\Core\Framework\Context;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepository;
use Shopware\Core\Framework\Uuid\Uuid;
use Symfony\Component\HttpFoundation\JsonResponse;

class WebShopLogger
{
    /**
     * @var EntityRepository
     */
    public $logEntryRepository;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        EntityRepository $logEntryRepository,
        LoggerInterface $logger
    ) {
        $this->logEntryRepository = $logEntryRepository;
        $this->logger = $logger;
    }

    public function addOrderLog($context, $logData)
    {
        try {
            $this->addEntry('Webshopnl order import data', $context, null, $logData);
            $this->logger->debug('Webshopnl order import data: ', $logData);
            return new JsonResponse(['type' => 'Success']);
        } catch (UniqueConstraintViolationException $e) {
            return new JsonResponse(['type' => 'Failed']);
        }
    }

    /**
     * @param  $message
     * @param Context $context
     * @param Exception|null $exception
     * @param array|null $additionalData
     * @param int $level
     */
    public function addEntry(
        $message,
        Context $context,
        ?Exception $exception = null,
        ?array $additionalData = null,
        int $level = Logger::DEBUG
    ): void {
        if (!\is_array($additionalData)) {
            $additionalData = [];
        }

        // Add exception to array
        if ($exception !== null) {
            $additionalData['error'] = [
                'message' => $exception->getMessage(),
                'trace' => $exception->getTrace(),
            ];
        }

        // Add data to the log entry
        $logEntry = [
            'message' => mb_substr($message, 0, 255),
            'level' => $level,
            'channel' => mb_substr('MagmodulesWebshopnl', 0, 255),
            'context' => [
                'source' => 'MagmodulesWebshopnl',
                'trackingData' => $additionalData
            ],
        ];

        $this->logEntryRepository->create([$logEntry], $context);
    }
}